﻿namespace Code6587EN.Ch01.ApplyMasterAndLogoToAll
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using System;

    /// <summary>
    /// Console Application to apply a Master Page and Logo to all Site Collections
    /// in all content Web Applications
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Iterate through each Content Web Application
            foreach (var webApp in SPWebService.ContentService.WebApplications)
            {
                // Iterate through each Site Collection in the Web Application
                foreach (SPSite site in webApp.Sites)
                {
                    // Ensure Site Collection is in 2013 mode
                    if (site.CompatibilityLevel == 15)
                    {
                        // Iterate through each Site in the Site Collection
                        foreach (SPWeb web in site.AllWebs)
                        {
                            // Ensure Site exists
                            if (web.Exists)
                            {
                                // Set properties
                                web.SiteLogoUrl = "/SiteAssets/logo.png";
                                web.SiteLogoDescription = "My Code Site";
                                web.MasterUrl = "/_catalogs/masterpages/seattle.master";
                                web.CustomMasterUrl = "/_catalogs/masterpages/seattle.master";

                                // Update the Site
                                web.Update();
                            }

                            // Dispose the Site
                            web.Dispose();
                        }
                    }
                    // Dispose the Site Collection
                    site.Dispose();
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
